/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.system.dao.MCodeDao;
import jp.mosp.system.dto.MCodeDto;
import jp.mosp.system.vo.LeaveEarlyReasonCardVo;

public class LeaveEarlyReasonCardAction extends MosPAction {

	// R}h
	private static final String CMD_LEAVE_EARLY_REASON_CARD_SHOW   = "S2530";	// \
	private static final String CMD_LEAVE_EARLY_REASON_CARD_UPDATE = "S2538";	// XV

	/**
	 * RXgN^
	 */
	public LeaveEarlyReasonCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmSystemAuth();
		// VO̎擾
		LeaveEarlyReasonCardVo vo = new LeaveEarlyReasonCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// R}h̏
		if (cmd.equals(CMD_LEAVE_EARLY_REASON_CARD_SHOW)) {
			// \
			show(vo, dao);
			// [hݒ
			vo.setMode(LeaveEarlyReasonCardVo.MODE_UPDATE);
		} else if (cmd.equals(CMD_LEAVE_EARLY_REASON_CARD_UPDATE)) {
			// ޗRXV
			for (int i = 0; i < 10; i++) {
				// ͒l擾
				vo.setParams(request, i);
				// p[^̑ÓmF
				vo.validateLeaveEarlyReason(i);
				// ޗRXV
				updateLeaveEarly(vo, dao, i);
			}
			// R~bg
			commit();
			// [hݒ
			vo.setMode(LeaveEarlyReasonCardVo.MODE_UPDATE);
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
			// \
			show(vo, dao);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * ޗR
	 * @param vo ΏVoCX^X
	 * @throws Exception
	 */
	private void show(LeaveEarlyReasonCardVo vo, MCodeDao dao) throws Exception {
		// ޗR
		vo.setFieldsLeaveEarlyReason(dao.findForCondition(CommonConst.TID_LEAVE_EARLY_REASON));
	}

	/**
	 * f[^XViޗRj
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @throws Exception
	 */
	private void updateLeaveEarly(LeaveEarlyReasonCardVo vo, MCodeDao dao, int i) throws Exception {
		// DTȌ
		MCodeDto dto = new MCodeDto();
		// DTȌ
		vo.setDtoFieldLeaveEarlyReason(dto, i);
		// rmF
		chkExclusive(dao.findForKey(dto.getTId(), dto.getTCode()), dao.findForUpdate(dto.getTId(), dto.getTCode()), vo);
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		chkUpdate(dao.findForKey(dto.getTId(), dto.getTCode()));
	}

}
